'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../hooks/index.js');
var index = require('../../../hooks/use-namespace/index.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpGroupContainer"
  },
  __name: "groupContainer",
  props: {
    title: { type: String, required: false, default: "" },
    isBorder: { type: Boolean, required: false, default: false }
  },
  setup(__props) {
    const bem = index.useNamespace("group");
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          class: vue.normalizeClass([vue.unref(bem).e("container"), { "is-border": __props.isBorder }])
        },
        [
          __props.title || _ctx.$slots.toolbar ? (vue.openBlock(), vue.createElementBlock(
            "div",
            {
              key: 0,
              class: vue.normalizeClass(vue.unref(bem).e("header"))
            },
            [
              __props.title ? (vue.openBlock(), vue.createElementBlock(
                "div",
                {
                  key: 0,
                  class: vue.normalizeClass(vue.unref(bem).e("title"))
                },
                vue.toDisplayString(__props.title),
                3
                /* TEXT, CLASS */
              )) : vue.createCommentVNode("v-if", true),
              _ctx.$slots.toolbar ? (vue.openBlock(), vue.createElementBlock(
                "div",
                {
                  key: 1,
                  class: vue.normalizeClass(vue.unref(bem).e("toolbar"))
                },
                [
                  vue.renderSlot(_ctx.$slots, "toolbar")
                ],
                2
                /* CLASS */
              )) : vue.createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          )) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode(
            "div",
            {
              class: vue.normalizeClass(vue.unref(bem).e("content"))
            },
            [
              vue.renderSlot(_ctx.$slots, "content")
            ],
            2
            /* CLASS */
          )
        ],
        2
        /* CLASS */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=groupContainer.vue2.js.map
