import type { Accessory } from './accessory';
import type { BaseWorkflowForm, TaskType } from './workflow';
export type FormRenderType = 'NORMAL' | 'DESIGN';
export type FormWidgetDisplayType = 'EDITABLE' | 'READONLY' | 'HIDDEN';
export interface DeptSnInfo {
    appCode: string;
    deptId: string;
    deptPath: string;
    snTitle: string;
}
export interface FormDefineInfo {
    appCode: string;
    formCode: string;
    formName: string;
    formCategory: string;
    formSn: string;
    renderType: FormRenderType;
    urlTemplate: string;
    enabled: boolean;
    formDescription: string;
}
export interface FormWorkflowRelationInfo {
    appCode: string;
    formCode: string;
    deptId: string;
    deptPath: string;
    processRange: number;
    processCode: string;
    processName: string;
}
export interface FormDesignInfo {
    appCode: string;
    formCode: string;
    widgetJson: string;
    scenes: Array<FormDesignSceneInfo>;
}
export interface FormDesignSceneInfo {
    appCode: string;
    formCode: string;
    sceneCode: string;
    sceneName: string;
    widgets: Array<FormDesignSceneWidgetInfo>;
}
export interface FormDesignSceneWidgetInfo {
    appCode: string;
    formCode: string;
    sceneCode: string;
    widgetCode: string;
    displayType: FormWidgetDisplayType;
}
export interface FormDesignDataQueryInfo {
    appCode: string;
    formTitle: string;
    issueUserId: string;
    beginDate: string;
    endDate: string;
    pageIndex: number;
    pageSize: number;
}
export interface FormDesignDataInfo {
    formId: string;
    appCode: string;
    formCode: string;
    formTitle: string;
    issueUserId: string;
    issueUserName: string;
    issueUserParentId: string;
    issueUserFullPathName: string;
    createTime: string;
    completeTime: string;
    extendData: Record<string, unknown>;
    accessories: Array<Accessory>;
}
export interface WFFormDesignDataInfo extends BaseWorkflowForm {
    formCode: string;
    extendData: Record<string, unknown>;
    accessories: Array<Accessory>;
}
export interface WFTaskQueryInfo {
    type: TaskType;
    pageSize: number;
    pageIndex: number;
}
