'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var index = require('element-plus/es/utils/index');
var elementPlus = require('element-plus');
var ElFocusTrap = require('element-plus/es/components/focus-trap/index');
var index$2 = require('../../../../svg-icons/vue/dist/index.js');
var dialogContent = require('./dialog-content.js');
require('../../../hooks/index.js');
var index$1 = require('../../../hooks/use-draggable-resize/index.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpDialogContent"
  },
  __name: "dialogContent",
  props: dialogContent.dialogContentProps,
  emits: ["close", "minusChange"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const { dialogRef, headerRef, bodyId, ns, style } = vue.inject(elementPlus.dialogInjectionKey);
    const { focusTrapRef } = vue.inject(ElFocusTrap.FOCUS_TRAP_INJECTION_KEY);
    const composeDialogRef = index.composeRefs(focusTrapRef, dialogRef);
    const draggable = vue.computed(() => props.draggable);
    const overflow = vue.computed(() => props.overflow);
    const isFullscreen = vue.computed(() => props.fullscreen);
    const resizable = vue.computed(() => props.resizable);
    const alignCenter = vue.computed(() => props.alignCenter);
    const { resetPosition, resetSize, onExpand, onCompress, onMinus, fullscreen, minus } = index$1.useDraggableAndResizable(
      dialogRef,
      headerRef,
      draggable,
      resizable,
      isFullscreen,
      alignCenter,
      overflow
    );
    const dialogKls = vue.computed(() => [
      ns.b(),
      ns.is("fullscreen", fullscreen.value),
      ns.is("minus", minus.value),
      ns.is("draggable", props.draggable),
      ns.is("resizable", props.resizable),
      ns.is("align-center", props.alignCenter),
      { [ns.m("center")]: props.center }
    ]);
    const onClose = () => {
      emit("close");
    };
    const _onMinus = () => {
      onMinus();
      emit("minusChange", minus.value);
    };
    const _onCompress = () => {
      onCompress();
      emit("minusChange", minus.value);
    };
    __expose({
      resetPosition,
      resetSize
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          ref: vue.unref(composeDialogRef),
          class: vue.normalizeClass(dialogKls.value),
          style: vue.normalizeStyle(vue.unref(style)),
          tabindex: "-1"
        },
        [
          vue.createElementVNode(
            "header",
            {
              ref_key: "headerRef",
              ref: headerRef,
              class: vue.normalizeClass([vue.unref(ns).e("header"), { "show-close": _ctx.showClose }])
            },
            [
              vue.renderSlot(_ctx.$slots, "header", {}, () => [
                vue.createElementVNode("span", {
                  role: "heading",
                  "aria-level": _ctx.ariaLevel,
                  class: vue.normalizeClass(vue.unref(ns).e("title"))
                }, vue.toDisplayString(_ctx.title), 11, ["aria-level"])
              ]),
              vue.createElementVNode(
                "div",
                {
                  class: vue.normalizeClass(vue.unref(ns).e("headerbtns"))
                },
                [
                  resizable.value ? (vue.openBlock(), vue.createElementBlock(
                    vue.Fragment,
                    { key: 0 },
                    [
                      !vue.unref(minus) ? (vue.openBlock(), vue.createElementBlock(
                        "button",
                        {
                          key: 0,
                          "aria-label": "\u6700\u5C0F\u5316",
                          class: vue.normalizeClass(vue.unref(ns).e("headerbtn")),
                          type: "button",
                          onClick: _onMinus
                        },
                        [
                          vue.createVNode(vue.unref(elementPlus.ElIcon), {
                            class: vue.normalizeClass(vue.unref(ns).e("close")),
                            size: 18
                          }, {
                            default: vue.withCtx(() => [
                              vue.createVNode(vue.unref(index$2.Minus))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class"])
                        ],
                        2
                        /* CLASS */
                      )) : vue.createCommentVNode("v-if", true),
                      !vue.unref(fullscreen) && !vue.unref(minus) ? (vue.openBlock(), vue.createElementBlock("button", {
                        key: 1,
                        "aria-label": "\u6700\u5927\u5316",
                        class: vue.normalizeClass(vue.unref(ns).e("headerbtn")),
                        type: "button",
                        onClick: vue.unref(onExpand)
                      }, [
                        vue.createVNode(vue.unref(elementPlus.ElIcon), {
                          class: vue.normalizeClass(vue.unref(ns).e("close")),
                          size: 18
                        }, {
                          default: vue.withCtx(() => [
                            vue.createVNode(vue.unref(index$2.FullScreen))
                          ]),
                          _: 1
                          /* STABLE */
                        }, 8, ["class"])
                      ], 10, ["onClick"])) : (vue.openBlock(), vue.createElementBlock(
                        "button",
                        {
                          key: 2,
                          "aria-label": "\u8FD8\u539F",
                          class: vue.normalizeClass(vue.unref(ns).e("headerbtn")),
                          type: "button",
                          onClick: _onCompress
                        },
                        [
                          vue.createVNode(vue.unref(elementPlus.ElIcon), {
                            class: vue.normalizeClass(vue.unref(ns).e("close")),
                            size: 18
                          }, {
                            default: vue.withCtx(() => [
                              vue.createVNode(vue.unref(index$2.CopyDocument))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class"])
                        ],
                        2
                        /* CLASS */
                      ))
                    ],
                    64
                    /* STABLE_FRAGMENT */
                  )) : vue.createCommentVNode("v-if", true),
                  _ctx.showClose ? (vue.openBlock(), vue.createElementBlock(
                    "button",
                    {
                      key: 1,
                      "aria-label": "\u5173\u95ED",
                      class: vue.normalizeClass(vue.unref(ns).e("headerbtn")),
                      type: "button",
                      onClick: onClose
                    },
                    [
                      vue.createVNode(vue.unref(elementPlus.ElIcon), {
                        class: vue.normalizeClass(vue.unref(ns).e("close"))
                      }, {
                        default: vue.withCtx(() => [
                          (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.closeIcon || vue.unref(index$2.Close))))
                        ]),
                        _: 1
                        /* STABLE */
                      }, 8, ["class"])
                    ],
                    2
                    /* CLASS */
                  )) : vue.createCommentVNode("v-if", true)
                ],
                2
                /* CLASS */
              )
            ],
            2
            /* CLASS */
          ),
          vue.createElementVNode("div", {
            id: vue.unref(bodyId),
            class: vue.normalizeClass(vue.unref(ns).e("body"))
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 10, ["id"]),
          _ctx.$slots.footer ? (vue.openBlock(), vue.createElementBlock(
            "footer",
            {
              key: 0,
              class: vue.normalizeClass(vue.unref(ns).e("footer"))
            },
            [
              vue.renderSlot(_ctx.$slots, "footer")
            ],
            2
            /* CLASS */
          )) : vue.createCommentVNode("v-if", true)
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=dialogContent.vue2.js.map
