'use strict';

const opt = Object.prototype.toString;
function isFunction(obj) {
  return typeof obj === "function";
}
function isString(obj) {
  return opt.call(obj) === "[object String]";
}
function isObject(obj) {
  return opt.call(obj) === "[object Object]";
}
function isArray(obj) {
  return opt.call(obj) === "[object Array]";
}
function isNumber(obj) {
  return opt.call(obj) === "[object Number]" && obj === obj;
}
function isFile(obj) {
  return opt.call(obj) === "[object File]";
}
function isRegExp(obj) {
  return opt.call(obj) === "[object RegExp]";
}
function isBlob(obj) {
  return opt.call(obj) === "[object Blob]";
}
function isWindow(obj) {
  return obj === window;
}

exports.isArray = isArray;
exports.isBlob = isBlob;
exports.isFile = isFile;
exports.isFunction = isFunction;
exports.isNumber = isNumber;
exports.isObject = isObject;
exports.isRegExp = isRegExp;
exports.isString = isString;
exports.isWindow = isWindow;
//# sourceMappingURL=istype.js.map
