'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var elementPlus = require('element-plus');
require('./TableOperator.vue.js');
require('../../../hooks/index.js');
var index$1 = require('../../table-toolbar/index.js');
var index = require('../../../hooks/use-namespace/index.js');
var TableOperator_vue_vue_type_script_setup_true_lang = require('./TableOperator.vue2.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpComplexTable",
    inheritAttrs: false
  },
  __name: "ComplexTable",
  props: {
    class: { required: false },
    style: { required: false },
    actions: { type: Array, required: true, default: () => [] },
    actionSpace: { type: Number, required: false, default: 12 },
    moreButtonText: { type: String, required: false },
    primaryColSpan: { type: Number, required: false },
    secondaryColSpan: { type: Number, required: false },
    actionsWidth: { type: Number, required: false },
    actionsTitle: { type: String, required: false, default: "\u64CD\u4F5C" },
    data: { type: Array, required: true },
    pagination: { type: Object, required: false },
    titleIsinline: { type: Boolean, required: false },
    loading: { type: Boolean, required: false, default: false },
    layout: { type: String, required: false },
    pageSizes: { type: Array, required: false }
  },
  emits: ["on-page-change", "on-size-change", "on-command"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const bem = index.useNamespace("advance");
    const innerTableRef = vue.ref();
    const emits = __emit;
    const props = __props;
    __expose({
      innerTableRef
    });
    const enableSelection = vue.computed(() => {
      return props.actions.some((item) => item.limit === "more");
    });
    const theadActions = vue.computed(() => {
      return props.actions.filter((item) => item.position !== void 0 || item.limit === "more" || item.limit === "none");
    });
    const inlineActions = vue.computed(() => {
      return props.actions.filter((item) => item.position === void 0 && item.limit === "one");
    });
    const hasToolBar = vue.computed(() => {
      return theadActions.value.length > 0;
    });
    const hasOne = vue.computed(() => {
      return inlineActions.value.length > 0;
    });
    const selectedRows = vue.ref([]);
    function isSelectedRow({ row }) {
      const isSelected = selectedRows.value.includes(row);
      if (isSelected) {
        return "is-selected";
      }
      return void 0;
    }
    function onSelectionChange(rows) {
      selectedRows.value = rows;
    }
    function onPageChange(currentPage) {
      if (props.pagination && props.pagination.visible) {
        emits("on-page-change", currentPage);
      }
    }
    function onSizeChange(pageSize) {
      if (props.pagination && props.pagination.visible) {
        emits("on-size-change", pageSize);
      }
    }
    function onInlineAction(command, rows, rowIndex) {
      emits("on-command", command, rows, rowIndex);
    }
    function onCommand(command, rows) {
      emits("on-command", command, rows);
    }
    return (_ctx, _cache) => {
      const _directive_cacploading = vue.resolveDirective("cacploading");
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          class: vue.normalizeClass([vue.unref(bem).e("layout"), _ctx.$props.class])
        },
        [
          hasToolBar.value || _ctx.$slots.title ? (vue.openBlock(), vue.createElementBlock(
            "div",
            {
              key: 0,
              class: vue.normalizeClass([vue.unref(bem).e("toolbar"), __props.titleIsinline ? "is-line" : ""])
            },
            [
              _ctx.$slots.title ? vue.renderSlot(_ctx.$slots, "title", { key: 0 }) : vue.createCommentVNode("v-if", true),
              vue.createVNode(vue.unref(index$1.CacpTableToolbar), {
                rows: selectedRows.value,
                actions: theadActions.value,
                onOnCommand: onCommand,
                primaryColSpan: __props.primaryColSpan,
                secondaryColSpan: __props.secondaryColSpan,
                moreButtonText: __props.moreButtonText,
                space: __props.actionSpace
              }, null, 8, ["rows", "actions", "primaryColSpan", "secondaryColSpan", "moreButtonText", "space"])
            ],
            2
            /* CLASS */
          )) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode(
            "div",
            {
              class: vue.normalizeClass(vue.unref(bem).e("grid"))
            },
            [
              vue.withDirectives((vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElTable), vue.mergeProps({
                ref_key: "innerTableRef",
                ref: innerTableRef,
                data: __props.data,
                onSelectionChange
              }, _ctx.$attrs, {
                class: "table-inner",
                "row-class-name": isSelectedRow
              }), vue.createSlots({
                default: vue.withCtx(() => [
                  enableSelection.value ? (vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElTableColumn), {
                    key: 0,
                    fixed: "",
                    type: "selection",
                    width: "50"
                  })) : vue.createCommentVNode("v-if", true),
                  vue.renderSlot(_ctx.$slots, "default"),
                  hasOne.value ? (vue.openBlock(), vue.createBlock(TableOperator_vue_vue_type_script_setup_true_lang.default, {
                    key: 1,
                    actions: inlineActions.value,
                    title: __props.actionsTitle,
                    onInlineAction,
                    width: __props.actionsWidth
                  }, null, 8, ["actions", "title", "width"])) : vue.createCommentVNode("v-if", true)
                ]),
                _: 2
                /* DYNAMIC */
              }, [
                _ctx.$slots.append ? {
                  name: "append",
                  fn: vue.withCtx(() => [
                    vue.renderSlot(_ctx.$slots, "append")
                  ]),
                  key: "0"
                } : void 0
              ]), 1040, ["data"])), [
                [_directive_cacploading, __props.loading]
              ])
            ],
            2
            /* CLASS */
          ),
          __props.pagination && __props.pagination.visible ? (vue.openBlock(), vue.createElementBlock(
            "div",
            {
              key: 1,
              class: vue.normalizeClass(vue.unref(bem).e("pagination"))
            },
            [
              vue.createVNode(vue.unref(elementPlus.ElPagination), vue.mergeProps({
                background: "",
                "current-page": __props.pagination.currentPage,
                "page-size": __props.pagination.pageSize,
                "onUpdate:currentPage": onPageChange,
                "onUpdate:pageSize": onSizeChange
              }, __props.pagination, {
                total: __props.pagination.total,
                layout: __props.layout || "total,sizes,->, prev, pager, next, jumper",
                pageSizes: __props.pageSizes
              }), null, 16, ["current-page", "page-size", "total", "layout", "pageSizes"])
            ],
            2
            /* CLASS */
          )) : vue.createCommentVNode("v-if", true)
        ],
        2
        /* CLASS */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=ComplexTable.vue2.js.map
